----for WOB --------
db_airbases = {
	['Abu al-Duhur'] = {
		ATC_frequency = {250.45, 122.2, 38.9, 4},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 36,
		LimitedSmallParkNb = '',
		airdromeId = 1,
		code = {
			ICAO = 'OS57',
		},
		divert = false,
		elevation = 250,
		parkAlertSAR = {
			{
				x = 76257.122626784,
				y = 110047.47583247,
			},
			{
				x = 76253.040040998,
				y = 110204.54877861,
			},
			{
				x = 76252.334420431,
				y = 110471.45511631,
			},
			{
				x = 76253.34819355,
				y = 110608.31448734,
			},
			{
				x = 76239.456316511,
				y = 110808.73755569,
			},
			{
				x = 76227.004787277,
				y = 110999.66100393,
			},
			{
				x = 76210.4027483,
				y = 111240.39056911,
			},
			{
				x = 76193.800709322,
				y = 111429.23876249,
			},
		},
		runways = {
			{
				hdg = 88,
				length = 2800,
				name = '09-27',
				x = 76048.957031,
				y = 111344.925781,
			},
		},
		side = 'red',
		startup = 900,
		x = 76048.957031,
		y = 111344.925781,
	},
	['Adana Sakirpasa'] = {
		ATC_frequency = {251, 121.1, 39.45, 4.275},
		ILS = 'RNW 05 : 108.70 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 39,
		LimitedSmallParkNb = '',
		NDB = '395',
		VOR = '112.70',
		airdromeId = 2,
		code = {
			ICAO = 'LTAF',
		},
		divert = true,
		elevation = 17,
		parkAlertSAR = {
			{
				x = 218721.10548537,
				y = -49265.606154432,
			},
			{
				x = 218886.70376523,
				y = -48999.878682106,
			},
			{
				x = 218959.87509819,
				y = -48909.102216404,
			},
			{
				x = 219044.59979951,
				y = -48821.076552693,
			},
			{
				x = 219131.52514242,
				y = -48698.940944295,
			},
			{
				x = 219196.44406941,
				y = -48486.579030593,
			},
			{
				x = 219275.66716675,
				y = -48372.145667769,
			},
			{
				x = 219325.18160259,
				y = -48287.420966447,
			},
		},
		runways = {
			{
				hdg = 50,
				length = 2600,
				name = '05-23',
				x = 219468.65625,
				y = -48332.732422,
			},
		},
		side = 'blue',
		startup = 300,
		x = 219468.65625,
		y = -48332.732422,
	},
	Akrotiri = {
		ATC_frequency = {251.75, 128, 40.2, 4.65},
		ILS = 'RNW 28 : 109.70 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 41,
		LimitedSmallParkNb = '',
		NDB = '365',
		TACAN = '107X',
		airdromeId = 44,
		code = {
			ICAO = 'LCRA',
		},
		divert = true,
		elevation = 21,
		parkAlertSAR = {
			{
				x = -35409.105788963,
				y = -270083.67923194,
			},
			{
				x = -35459.777628662,
				y = -270001.10290057,
			},
			{
				x = -35528.278448997,
				y = -269825.62819643,
			},
			{
				x = -35558.306205857,
				y = -269726.16125183,
			},
			{
				x = -35639.944169818,
				y = -269535.67266926,
			},
			{
				x = -35675.602131088,
				y = -269425.88368324,
			},
			{
				x = -35746.871071825,
				y = -269259.66859599,
			},
			{
				x = -35797.157918382,
				y = -269132.94574266,
			},
		},
		runways = {
			{
				hdg = 106,
				length = 2600,
				name = '10-28',
				x = -35778.628906,
				y = -268906.125,
			},
		},
		side = 'blue',
		startup = 300,
		x = -35778.628906,
		y = -268906.125,
	},
	['Al Qusayr'] = {
		ATC_frequency = {251.55, 119.2, 40, 4.55},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 34,
		LimitedSmallParkNb = '',
		airdromeId = 3,
		code = {
			ICAO = 'OS70',
		},
		divert = false,
		elevation = 527,
		parkAlertSAR = {
			{
				x = -51535.987412662,
				y = 58838.449930879,
			},
			{
				x = -51580.703508894,
				y = 59070.673018877,
			},
			{
				x = -51606.631329399,
				y = 59201.815183458,
			},
			{
				x = -51633.686446447,
				y = 59367.152009865,
			},
			{
				x = -51655.480846292,
				y = 59496.791112388,
			},
			{
				x = -51686.669384,
				y = 59638.078945862,
			},
			{
				x = -51721.615576854,
				y = 59778.991013822,
			},
			{
				x = -51734.767369864,
				y = 59869.174737317,
			},
		},
		runways = {
			{
				hdg = 96,
				length = 2800,
				name = '10-28',
				x = -51906.964844,
				y = 60013.205078,
			},
		},
		side = 'red',
		startup = 900,
		x = -51906.964844,
		y = 60013.205078,
	},
	['Al-Dumayr'] = {
		ATC_frequency = {252.85, 120.3, 41.3, 5.2},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 57,
		LimitedSmallParkNb = '',
		airdromeId = 9,
		code = {
			ICAO = 'OS61',
		},
		divert = false,
		elevation = 630,
		parkAlertSAR = {
			{
				x = -159195.10934722,
				y = 72582.692865693,
			},
			{
				x = -159161.45330125,
				y = 72662.404553521,
			},
			{
				x = -159137.98263761,
				y = 72724.845375654,
			},
			{
				x = -159101.60888217,
				y = 72796.832601478,
			},
			{
				x = -159076.4866716,
				y = 72867.101973077,
			},
			{
				x = -159046.26720091,
				y = 72935.550894635,
			},
			{
				x = -158964.71103906,
				y = 73108.493648571,
			},
			{
				x = -158920.29205805,
				y = 73211.531120916,
			},
		},
		runways = {
			{
				hdg = 60,
				length = 2800,
				name = '06-24',
				x = -158713.039063,
				y = 73973.316406,
			},
		},
		side = 'red',
		startup = 900,
		x = -158713.039063,
		y = 73973.316406,
	},
	Aleppo = {
		ATC_frequency = {250.85, 119.1, 39.3, 4.2},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 8,
		LimitedSmallParkNb = '',
		NDB = '396',
		VOR = '114.50',
		airdromeId = 27,
		code = {
			ICAO = 'OSAP',
		},
		divert = false,
		elevation = 383,
		parkAlertSAR = {
			{
				x = 125488.34555905,
				y = 124433.74102495,
			},
			{
				x = 125501.60851674,
				y = 124343.55291266,
			},
			{
				x = 125512.88203078,
				y = 124254.02794826,
			},
			{
				x = 125522.82924904,
				y = 124169.80816693,
			},
			{
				x = 125529.46072789,
				y = 124097.52504752,
			},
			{
				x = 125536.75535462,
				y = 124021.26304081,
			},
			{
				x = 125538.74479827,
				y = 123924.44344968,
			},
			{
				x = 125611.02791768,
				y = 123783.85609817,
			},
		},
		runways = {
			{
				hdg = 06,
				length = 3026,
				name = '06-24',
				x = 125576.863281,
				y = 123125.304688,
			},
		},
		side = 'red',
		startup = 900,
		x = 125576.863281,
		y = 123125.304688,
	},
	['Amman'] = {
		ATC_frequency = {252.8, 118.1, 41.25, 5.175},
		ILS = 'RWY 24 : 109.5 || ',							-- ILS : optionnel
		LimitedParkNb = 78,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
		VOR = '116.30',
		airdromeId = 67,
		code = {
			ICAO = 'OJAM',
		},
		divert = true,
		elevation = 839,
		parkAlertSAR = {
			{
				["y"] = -926.45912613136,
				["x"] = -338424.88469566,
			},
			{
				["y"] = -898.61540712753,
				["x"] = -338413.53945621,
			},			
			{
				["y"] = -870.92948331084,
				["x"] = -338401.46554101,
			},
		},
		runways = {
			{
				hdg = 92,
				length = 2800,
				name = '09-27',
				x = -338506.90625,
				y = -1511.995987,
			},
		},
		side = 'blue',
		startup = 900,
		x = -338506.90625,
		y = -1511.995987,
	},
	['An Nasiriyah'] = {
		ATC_frequency = {252.05, 122.3, 40.5, 4.8},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 20,
		LimitedSmallParkNb = '',
		airdromeId = 4,
		code = {
			ICAO = '0564',
		},
		divert = false,
		elevation = 839,
		parkAlertSAR = {
			{
				x = -125495.60622586,
				y = 84524.440132902,
			},
			{
				x = -125413.70702973,
				y = 84608.132742092,
			},
			{
				x = -125324.63418138,
				y = 84707.368264417,
			},
			{
				x = -125240.94157219,
				y = 84779.702590931,
			},
			{
				x = -125090.29487564,
				y = 84941.109765798,
			},
			{
				x = -124982.6900924,
				y = 85048.714549042,
			},
			{
				x = -124879.86774397,
				y = 85152.732506178,
			},
			{
				x = -124772.86076507,
				y = 85237.620724071,
			},
		},
		runways = {
			{
				hdg = 39,
				length = 2800,
				name = '04-22',
				x = -124683.738281,
				y = 85510.820313,
			},
		},
		side = 'red',
		startup = 900,
		x = -124683.738281,
		y = 85510.820313,
	},
	['At Tanf'] = {
		ATC_frequency = {252.65, 121.1, 41.1, 5.1},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 2,
		LimitedSmallParkNb = '',
		airdromeId = 63,
		code = {
			ICAO = 'HELIPORT',
		},
		divert = true,
		elevation = 209,
		parkAlertSAR = {
			{
				x = -172085.94004455,
				y = 247004.24380966,
			},
			{
				x = -172156.18230345,
				y = 247009.56903507,
			},
			{
				x = -172026.09465429,
				y = 247175.15818693,
			},
			{
				x = -172097.35124184,
				y = 247167.2971399,
			},
			{
				x = -171967.90475367,
				y = 247070.68803995,
			},
			{
				x = -172204.82565734,
				y = 247371.23035175,
			},
			{
				x = -172214.20072209,
				y = 247423.46285537,
			},
			{
				x = -172249.10526825,
				y = 247358.58981854,
			},
		},
		side = 'red',
		startup = 300,
		x = -172339.65625,
		y = 247058.453125,
	},
	['Bassel Al-Assad'] = {
		ATC_frequency = {250.55, 118.1, 39, 4.05},
		ILS = 'RNW 17R : 109.10 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 53,
		LimitedSmallParkNb = '',
		NDB = '414',
		VOR = '114.80',
		airdromeId = 21,
		code = {
			ICAO = 'OSKL',
		},
		divert = false,
		elevation = 29,
		parkAlertSAR = {
			{
				x = 40665.996456489,
				y = 5786.0236357192,
			},
			{
				x = 40731.594730771,
				y = 5783.6273517272,
			},
			{
				x = 40801.985573038,
				y = 5781.2310677351,
			},
			{
				x = 40870.57920231,
				y = 5784.8254937232,
			},
			{
				x = 40948.158896553,
				y = 5784.5259582242,
			},
			{
				x = 41028.380493897,
				y = 5775.3809297647,
			},
			{
				x = 41110.814704075,
				y = 5734.0595204377,
			},
			{
				x = 41223.062883249,
				y = 5761.2309358795,
			},
		},
		runways = {
			{
				hdg = 173,
				length = 2400,
				name = '17L-35R',
				x = 41994.498047,
				y = 5841.909424,
			},
			{
				hdg = 173,
				length = 2700,
				name = '17R-335L',
				x = 41941.84913286,
				y = 5654.6576210905,
			},
		},
		side = 'red',
		startup = 900,
		x = 41994.498047,
		y = 5841.909424,
	},
	['Beirut-Rafic Hariri'] = {
		ATC_frequency = {252.7, 118.9, 41.15, 5.125},
		ILS = 'RNW 03 : 110.70 || RNW 16 : 110.10 || RNW 17 : 109.50 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 34,
		LimitedSmallParkNb = '',
		NDB = '351',
		VOR = '112.60',
		airdromeId = 6,
		code = {
			ICAO = 'OLBA',
		},
		divert = false,
		elevation = 12,
		parkAlertSAR = {
			{
				x = -131188.9419634,
				y = -41065.546547452,
			},
			{
				x = -131280.76570937,
				y = -41133.329167205,
			},
			{
				x = -131384.94392298,
				y = -41216.471395376,
			},
			{
				x = -131494.46460909,
				y = -41291.933819338,
			},
			{
				x = -131596.97330005,
				y = -41371.069193139,
			},
			{
				x = -131669.43058323,
				y = -41427.165154315,
			},
			{
				x = -131741.88786642,
				y = -41485.264542675,
			},
			{
				x = -131829.6421261,
				y = -41554.860520365,
			},
		},
		runways = {
			{
				hdg = 30,
				length = 2100,
				name = '03-21',
				x = -133158.76271808,
				y = -42081.354413207,
			},
			{
				hdg = 164,
				length = 3100,
				name = '16-34',
				x = -131528.70232218,
				y = -42701.606091431,
			},
			{
				hdg = 174,
				length = 2300,
				name = '17-35',
				x = -131297.40891836,
				y = -42266.030402088,
			},
		},
		side = 'blue',
		startup = 600,
		x = -133158.76271808,
		y = -42081.354413207,
	},
	['CVN-71 Theodore Roosevelt'] = {
		LimitedParkNb = 9,
		side = 'blue',
		startup = 600,
		unitname = 'CVN-71 Theodore Roosevelt',
	},
	['CVN-75 Harry S. Truman'] = {
		LimitedParkNb = 9,
		side = 'blue',
		startup = 600,
		unitname = 'CVN-75 Harry S. Truman',
	},
	Damascus = {
		ATC_frequency = {252.75, 118.5, 41.2, 5.15},
		ILS = 'RNW 23R : 109.90 || RNW 05R : 111.10 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 90,
		LimitedSmallParkNb = '',
		NDB = 264,
		VOR = '116.00',
		airdromeId = 7,
		code = {
			ICAO = 'OSDI',
		},
		divert = false,
		elevation = 612,
		parkAlertSAR = {
			{
				x = -179756.35124575,
				y = 50859.524738289,
			},
			{
				x = -179701.3185396,
				y = 50927.422232882,
			},
			{
				x = -179644.85641252,
				y = 50993.175596066,
			},
			{
				x = -179590.53841685,
				y = 51055.355406904,
			},
			{
				x = -179533.36157929,
				y = 51126.826453844,
			},
			{
				x = -179408.28724715,
				y = 51290.495151336,
			},
			{
				x = -179347.53685725,
				y = 51363.395619215,
			},
			{
				x = -179198.16236914,
				y = 51532.067289993,
			},
		},
		runways = {
			{
				hdg = 45,
				length = 3500,
				name = '05L-23R',
				x = -178652.320313,
				y = 52081.296875,
			},
			{
				hdg = 45,
				length = 3500,
				name = '05R-23L',
				x = -181974.2406095,
				y = 51245.612651387,
			},
		},
		side = 'red',
		startup = 900,
		x = -178652.320313,
		y = 52081.296875,
	},
	['Deir ez-Zor'] = {
		ATC_frequency = {251.7, 118.1, 40.15, 4.625},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 5,
		LimitedSmallParkNb = '',
		NDB = '295',
		VOR = '117.00',
		airdromeId = 42,
		code = {
			ICAO = 'OSDZ',
		},
		divert = true,
		elevation = 218,
		parkAlertSAR = {
			{
				x = 25902.565752404,
				y = 388726.04875918,
			},
			{
				x = 25858.931322818,
				y = 388848.89216612,
			},
			{
				x = 25821.316013615,
				y = 388961.73809373,
			},
			{
				x = 25777.584393972,
				y = 389091.70969057,
			},
			{
				x = 25719.479444796,
				y = 389254.70936379,
			},
			{
				x = 25606.939332709,
				y = 389589.27154483,
			},
			{
				x = 25558.926295758,
				y = 389724.13619002,
			},
			{
				x = 25518.252831336,
				y = 389846.76821433,
			},
		},
		runways = {
			{
				hdg = 104,
				length = 2800,
				name = '10-28',
				x = 25468.005273424,
				y = 389741.85622156,
			},
		},
		side = 'red',
		startup = 300,
		x = 25468.005273424,
		y = 389741.85622156,
	},
	['Dyess AFB'] = {
		ATC_frequency = '0',
		BaseAirStart = true,
		divert = false,
		elevation = 0,
		side = 'blue',
		 x = 950000,
        y = -1000000,
	},
	Ercan = {
		ATC_frequency = {252, 120.2, 40.45, 4.775},
		ILS = 'RNW 29 : 108.30 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 7,
		LimitedSmallParkNb = '',
		VOR = '117.00',
		airdromeId = 49,
		code = {
			ICAO = 'LCEN',
		},
		divert = true,
		elevation = 95,
		parkAlertSAR = {
			{
				x = 24651.034229891,
				y = -219274.88098714,
			},
			{
				x = 24580.867828896,
				y = -219313.43395472,
			},
			{
				x = 24578.554650841,
				y = -219093.68203952,
			},
			{
				x = 24524.58049623,
				y = -218967.99936521,
			},
			{
				x = 24455.185154587,
				y = -218818.413851,
			},
			{
				x = 24444.714168592,
				y = -218497.1005425,
			},
			{
				x = 24419.878192666,
				y = -218352.60031893,
			},
			{
				x = 24363.432792833,
				y = -218212.61572734,
			},
		},
		runways = {
			{
				hdg = 110,
				length = 2600,
				name = '11-29',
				x = 24250.327148,
				y = -218240.28125,
			},
		},
		side = 'blue',
		startup = 600,
		x = 24250.327148,
		y = -218240.28125,
	},
	['Eyn Shemer'] = {
		ATC_frequency = {250, 123.4, 38.4, 3.75},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 14,
		LimitedSmallParkNb = '',
		airdromeId = 10,
		code = {
			ICAO = 'LLES',
		},
		divert = false,
		elevation = 34,
		parkAlertSAR = {
			{
				x = -283388.27610986,
				y = -93208.278846953,
			},
			{
				x = -283393.17739126,
				y = -93131.640628692,
			},
			{
				x = -283402.08881198,
				y = -93043.863134521,
			},
			{
				x = -283435.50663971,
				y = -92910.637394638,
			},
			{
				x = -283454.66619428,
				y = -92743.993827024,
			},
			{
				x = -283541.91332079,
				y = -92266.921484225,
			},
			{
				x = -283557.70044621,
				y = -92177.221907996,
			},
			{
				x = -283567.02920213,
				y = -92076.758382619,
			},
		},
		runways = {
			{
				hdg = 95,
				length = 1470,
				name = '09-27',
				x = -283538.6875,
				y = -92619.707031,
			},
		},
		side = 'blue',
		startup = 600,
		x = -283538.6875,
		y = -92619.707031,
	},
	Gaziantep = {
		ATC_frequency = {250.05, 120.1, 38.45, 3.775},
		ILS = 'RNW 28 : 109.10 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 12,
		LimitedSmallParkNb = '',
		NDB = '432',
		VOR = '116.70',
		airdromeId = 11,
		code = {
			ICAO = 'LTAJ',
		},
		divert = true,
		elevation = 698,
		parkAlertSAR = {
			{
				x = 210378.86633312,
				y = 146830.31497525,
			},
			{
				x = 210347.89978378,
				y = 146936.67834037,
			},
			{
				x = 210319.62597786,
				y = 147055.15905088,
			},
			{
				x = 210286.30327803,
				y = 147152.09781403,
			},
			{
				x = 210262.7417731,
				y = 147233.67447596,
			},
			{
				x = 210116.16618324,
				y = 147732.7365101,
			},
			{
				x = 210086.03280565,
				y = 147846.50538466,
			},
			{
				x = 210051.59465984,
				y = 147951.04975587,
			},
		},
		runways = {
			{
				hdg = 100,
				length = 2700,
				name = '10-28',
				x = 210314.796875,
				y = 147379.28125,
			},
		},
		side = 'blue',
		startup = 300,
		x = 210314.796875,
		y = 147379.28125,
	},
	Gazipasa = {
		ATC_frequency = {251.65, 119.25, 40.1, 4.6},
		ILS = 'RNW 08 : 108.50 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 6,
		LimitedSmallParkNb = '',
		NDB = '316',
		airdromeId = 41,
		code = {
			ICAO = 'LTFG',
		},
		divert = true,
		elevation = 40,
		parkAlertSAR = {
			{
				x = 210378.86633312,
				y = 146830.31497525,
			},
			{
				x = 210347.89978378,
				y = 146936.67834037,
			},
			{
				x = 210319.62597786,
				y = 147055.15905088,
			},
			{
				x = 210286.30327803,
				y = 147152.09781403,
			},
			{
				x = 210262.7417731,
				y = 147233.67447596,
			},
			{
				x = 210116.16618324,
				y = 147732.7365101,
			},
			{
				x = 210086.03280565,
				y = 147846.50538466,
			},
			{
				x = 210051.59465984,
				y = 147951.04975587,
			},
		},
		runways = {
			{
				hdg = 80,
				length = 2200,
				name = '08-26',
				x = 158144.617188,
				y = -319392.546875,
			},
		},
		side = 'blue',
		startup = 600,
		x = 158144.617188,
		y = -319392.546875,
	},
	Gecitkale = {
		ATC_frequency = {252.1, 120, 40.55, 4.825},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 3,
		LimitedSmallParkNb = '',
		NDB = '435',
		VOR = '114.30',
		airdromeId = 50,
		code = {
			ICAO = 'LCGK',
		},
		divert = true,
		elevation = 46,
		parkAlertSAR = {
			{
				x = 32190.94773128,
				y = -199518.28181088,
			},
			{
				x = 32185.482651521,
				y = -199419.91037521,
			},
			{
				x = 32182.750111641,
				y = -199343.39925858,
			},
			{
				x = 32139.029473567,
				y = -198660.26428868,
			},
			{
				x = 32126.733044109,
				y = -198531.83491434,
			},
			{
				x = 32117.16915453,
				y = -198330.99323319,
			},
			{
				x = 32108.971534891,
				y = -198218.95909812,
			},
			{
				x = 32101.43748813,
				y = -198076.21224923,
			},
		},
		runways = {
			{
				hdg = 88,
				length = 2700,
				name = '09-27',
				x = 32144.729634,
				y = -197767.51907,
			},
		},
		side = 'blue',
		startup = 600,
		x = 32144.729634,
		y = -197767.51907,
	},
	H3 = {
		ATC_frequency = {252.25, 122, 40.7, 4.9},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 52,
		LimitedSmallParkNb = '',
		airdromeId = 53,
		code = {
			ICAO = 'nil',
		},
		divert = false,
		elevation = 788,
		parkAlertSAR = {
			{
				x = -234873.67927996,
				y = 351390.7226178,
			},
			{
				x = -234908.45560875,
				y = 351476.39113506,
			},
			{
				x = -234950.01756267,
				y = 351577.32730886,
			},
			{
				x = -234989.03490716,
				y = 351673.17426382,
			},
			{
				x = -235313.43760591,
				y = 352498.67928275,
			},
			{
				x = -235362.53519285,
				y = 352639.5680105,
			},
			{
				x = -235435.11423442,
				y = 352823.15029211,
			},
			{
				x = -235268.09374062,
				y = 352377.18287101,
			},
		},
		runways = {
			{
				hdg = 59,
				length = 2900,
				name = '06-24',
				x = -237002.72102318,
				y = 352516.24571279,
			},
			{
				hdg = 108,
				length = 2800,
				name = '11-29',
				x = -235415.01381856,
				y = 352556.97552696,
			},
		},
		side = 'red',
		startup = 900,
		x = -237002.72102318,
		y = 352516.24571279,
	},
	['H3 Northwest'] = {
		ATC_frequency = {252.3, 122.1, 40.75, 4.925},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 21,
		LimitedSmallParkNb = '',
		airdromeId = 54,
		code = {
			ICAO = 'nil',
		},
		divert = false,
		elevation = 787,
		parkAlertSAR = {
			{
				x = -219779.53175954,
				y = 337411.58857045,
			},
			{
				x = -219582.38772144,
				y = 337498.1721007,
			},
			{
				x = -219879.4358329,
				y = 337572.76714214,
			},
			{
				x = -219662.31098013,
				y = 337674.00326982,
			},
			{
				x = -219950.03471141,
				y = 337728.61749659,
			},
			{
				x = -219760.88299918,
				y = 337825.85746133,
			},
			{
				x = -219939.37827691,
				y = 338121.57351847,
			},
			{
				x = -220036.61824165,
				y = 338280.08798154,
			},
		},
		runways = {
			{
				hdg = 117,
				length = 2400,
				name = '12-30',
				x = -220000.35156,
				y = 338483.561903,
			},
		},
		side = 'red',
		startup = 900,
		x = -220000.35156,
		y = 338483.561903,
	},
	['H3 Southwest'] = {
		ATC_frequency = {252.35, 122.4, 40.8, 4.95},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 22,
		LimitedSmallParkNb = '',
		airdromeId = 55,
		code = {
			ICAO = 'nil',
		},
		divert = false,
		elevation = 815,
		parkAlertSAR = {
			{
				x = -256151.24431358,
				y = 338344.05294293,
			},
			{
				x = -256220.15389886,
				y = 338419.22703595,
			},
			{
				x = -256312.5553882,
				y = 338546.08331793,
			},
			{
				x = -256412.78751223,
				y = 338677.63798073,
			},
			{
				x = -256083.90085525,
				y = 338599.33163382,
			},
			{
				x = -256163.77332909,
				y = 338683.90248848,
			},
			{
				x = -256245.21192986,
				y = 338757.51045456,
			},
			{
				x = -256318.81989595,
				y = 338834.25067453,
			},
		},
		runways = {
			{
				hdg = 116,
				length = 2400,
				name = '12-30',
				x = -256859.445313,
				y = 339219.1875,
			},
		},
		side = 'red',
		startup = 900,
		x = -256859.445313,
		y = 339219.1875,
	},
	H4 = {
		ATC_frequency = {250.1, 122.6, 38.5, 3.8},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 12,
		LimitedSmallParkNb = '',
		airdromeId = 12,
		code = {
			ICAO = 'OJHR',
		},
		divert = false,
		elevation = 688,
		parkAlertSAR = {
			{
				x = -279206.02866934,
				y = 206135.29960908,
			},
			{
				x = -279221.77248637,
				y = 206356.63915441,
			},
			{
				x = -279307.90042661,
				y = 206620.57961642,
			},
			{
				x = -279329.20088495,
				y = 206778.01778674,
			},
			{
				x = -279420.88546649,
				y = 207149.38664732,
			},
			{
				x = -279436.62928352,
				y = 207238.2929082,
			},
			{
				x = -279493.12180346,
				y = 207473.5240568,
			},
			{
				x = -279558.87539224,
				y = 207609.66176878,
			},
		},
		runways = {
			{
				hdg = 98,
				length = 2400,
				name = '10-28',
				x = -279366.765625,
				y = 207219.265625,
			},
		},
		side = 'blue',
		startup = 600,
		x = -279366.765625,
		y = 207219.265625,
	},
	Haifa = {
		ATC_frequency = {250.15, 127.8, 38.55, 3.825},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 11,
		LimitedSmallParkNb = '',
		airdromeId = 13,
		code = {
			ICAO = 'LLHA',
		},
		divert = false,
		elevation = 6,
		parkAlertSAR = {
			{
				x = -242366.22331102,
				y = -87830.073880102,
			},
			{
				x = -242414.85245288,
				y = -87819.463885514,
			},
			{
				x = -242458.76604159,
				y = -87805.611948135,
			},
			{
				x = -242514.58276553,
				y = -87676.148040663,
			},
			{
				x = -242492.10613756,
				y = -87606.470493979,
			},
			{
				x = -242477.12171892,
				y = -87558.520354326,
			},
			{
				x = -242459.14041655,
				y = -87502.32878442,
			},
			{
				x = -242437.41936143,
				y = -87405.208670878,
			},
		},
		runways = {
			{
				hdg = 157,
				length = 1000,
				name = '16-34',
				x = -242620.8125,
				y = -87704.417969,
			},
		},
		side = 'blue',
		startup = 600,
		x = -242620.8125,
		y = -87704.417969,
	},
	Hama = {
		ATC_frequency = {250.2, 118.05, 38.6, 3.85},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 46,
		LimitedSmallParkNb = '',
		airdromeId = 14,
		code = {
			ICAO = 'OS58',
		},
		divert = false,
		elevation = 300,
		parkAlertSAR = {
			{
				x = 8974.9694610055,
				y = 73177.782194338,
			},
			{
				x = 8962.2325703337,
				y = 73281.496875523,
			},
			{
				x = 8925.8414541284,
				y = 73466.727657008,
			},
			{
				x = 8902.7997274719,
				y = 73603.224765751,
			},
			{
				x = 8868.6567452525,
				y = 73787.787879426,
			},
			{
				x = 8816.9923997069,
				y = 73937.374920653,
			},
			{
				x = 8808.8122280523,
				y = 74070.984391012,
			},
			{
				x = 8799.2686944552,
				y = 74165.510819021,
			},
		},
		runways = {
			{
				hdg = 95,
				length = 2600,
				name = '09-27',
				x = 8662.594238,
				y = 74333.1875,
			},
		},
		side = 'red',
		startup = 300,
		x = 8662.594238,
		y = 74333.1875,
	},
	Hatay = {
		ATC_frequency = {250.25, 128.5, 38.65, 3.875},
		ILS = 'RNW 4 : 108.90 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 10,
		LimitedSmallParkNb = '',
		NDB = '336',
		VOR = '112.05',
		airdromeId = 15,
		code = {
			ICAO = 'LTDA',
		},
		divert = false,
		elevation = 78,
		parkAlertSAR = {
			{
				x = 146812.52049294,
				y = 38373.228686558,
			},
			{
				x = 146905.18784309,
				y = 38464.004866298,
			},
			{
				x = 147031.89626065,
				y = 38585.039772619,
			},
			{
				x = 147141.5841445,
				y = 38692.836486061,
			},
			{
				x = 147224.79564259,
				y = 38773.21122854,
			},
			{
				x = 147499.96093743,
				y = 39084.308761193,
			},
			{
				x = 147642.74430348,
				y = 39238.439149711,
			},
			{
				x = 147803.49378844,
				y = 39354.746130004,
			},
		},
		runways = {
			{
				hdg = 39,
				length = 2900,
				name = '04-22',
				x = 147687.484375,
				y = 39418.742188,
			},
		},
		side = 'blue',
		startup = 600,
		x = 147687.484375,
		y = 39418.742188,
	},
	['Herzliya'] = {
		ATC_frequency = {252.75, 122.2, 41.2, 5.150},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 48,
		LimitedSmallParkNb = '',
		airdromeId = 66,
		code = {
			ICAO = 'LLLHZ',
		},
		divert = true,
		elevation = 35,
		parkAlertSAR = {
			{
                ["y"] = -109755.86418024,
                ["x"] = -311861.30393996,
			},
			{
                ["y"] = -109918.07080846,
                ["x"] = -311806.10283687,
			},			
			{
                ["y"] = -110078.98003425,
                ["x"] = -311746.09318533,
			},
		},
		runways = {
			{
				hdg = 100,
				length = 820,
				name = '10-28',
				x = -311870.03125,
				y = -109913.132812,
			},
		},
		side = 'blue',
		startup = 900,
		x = -311870.03125,
		y = -109913.132812,
	},
	Incirlik = {
		ATC_frequency = {360.1, 122.1, 38.7, 3.9},
		ILS = 'RNW 23 : 111.70 || RNW 5 : 109.30 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 120,
		LimitedSmallParkNb = '',
		TACAN = '21X',
		airdromeId = 16,
		code = {
			ICAO = 'LTAG',
		},
		divert = true,
		elevation = 71,
		parkAlertSAR = {
			{
				x = 220639.25222613,
				y = -35861.47504021,
			},
			{
				x = 220688.65162407,
				y = -35784.028799259,
			},
			{
				x = 220803.23736147,
				y = -35596.336324425,
			},
			{
				x = 220861.82644891,
				y = -35524.266561989,
			},
			{
				x = 220910.56427387,
				y = -35443.382512061,
			},
			{
				x = 221033.96429876,
				y = -35256.208524726,
			},
			{
				x = 221076.99876122,
				y = -35186.731199788,
			},
			{
				x = 221142.32818616,
				y = -35094.958912369,
			},
		},
		runways = {
			{
				hdg = 49,
				length = 2900,
				name = '05-23',
				x = 221207.765625,
				y = -35240.335938,
			},
		},
		side = 'blue',
		startup = 900,
		x = 221207.765625,
		y = -35240.335938,
	},
	Jirah = {
		ATC_frequency = {250.3, 118.1, 38.75, 3.925},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 28,
		LimitedSmallParkNb = '',
		airdromeId = 17,
		code = {
			ICAO = 'OS62',
		},
		divert = false,
		elevation = 358,
		parkAlertSAR = {
			{
				x = 115267.32127493,
				y = 187135.52503884,
			},
			{
				x = 115535.49314164,
				y = 185742.71866501,
			},
			{
				x = 115240.84115826,
				y = 187264.14274835,
			},
			{
				x = 115498.73356098,
				y = 186018.68189372,
			},
			{
				x = 115429.47638003,
				y = 186369.76252639,
			},
			{
				x = 115367.67766472,
				y = 186687.28006367,
			},
			{
				x = 115337.84380216,
				y = 186846.03883231,
			},
			{
				x = 115302.68246414,
				y = 186995.20814513,
			},
		},
		runways = {
			{
				hdg = 95,
				length = 2900,
				name = '10-28',
				x = 115359.652344,
				y = 187020.734375,
			},
		},
		side = 'red',
		startup = 900,
		x = 115359.652344,
		y = 187020.734375,
	},
	Khalkhalah = {
		ATC_frequency = {250.35, 122.5, 38.8, 3.95},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 35,
		LimitedSmallParkNb = '',
		airdromeId = 18,
		code = {
			ICAO = '0569',
		},
		divert = false,
		elevation = 737,
		parkAlertSAR = {
			{
				x = -218806.42975805,
				y = 54793.734918449,
			},
			{
				x = -218732.7430896,
				y = 55196.248344805,
			},
			{
				x = -218709.71600572,
				y = 55321.515681154,
			},
			{
				x = -218449.97049947,
				y = 56371.550706432,
			},
			{
				x = -218419.57474873,
				y = 56495.896959425,
			},
			{
				x = -218361.54649734,
				y = 56674.587130393,
			},
			{
				x = -218322.86099641,
				y = 56922.358553025,
			},
			{
				x = -218292.46524568,
				y = 57077.10055675,
			},
		},
		runways = {
			{
				hdg = 71,
				length = 2800,
				name = '07-25',
				x = -218620.25,
				y = 56161.078125,
			},
			{
				hdg = 146,
				length = 2500,
				name = '15-33',
				x = -217203.91940269,
				y = 53276.85359013,
			},
		},
		side = 'red',
		startup = 900,
		x = -218620.25,
		y = 56161.078125,
	},
	['Kharab Ishk'] = {
		ATC_frequency = {252.5, 122.2, 40.95, 5.025},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 11,
		LimitedSmallParkNb = '',
		airdromeId = 59,
		code = {
			ICAO = 'HELIPORT',
		},
		divert = true,
		elevation = 431,
		parkAlertSAR = {
			{
				x = 164864.12887925,
				y = 245901.32386715,
			},
			{
				x = 164833.26009366,
				y = 245903.23327657,
			},
			{
				x = 164838.0336172,
				y = 245936.64794139,
			},
			{
				x = 164865.40181886,
				y = 245933.14735745,
			},
			{
				x = 164887.11066489,
				y = 245853.14674797,
			},
			{
				x = 164771.24587675,
				y = 245921.9966744,
			},
			{
				x = 164740.82886756,
				y = 245922.45065961,
			},
			{
				x = 164705.87200626,
				y = 245925.17457088,
			},
		},
		side = 'red',
		startup = 300,
		x = 164825.84375,
		y = 245883.84375,
	},
	['King Abdullah II'] = {
		---ATC_frequency = {251.9, 121.2, 40.35, 4.725},
		ILS = 'RNW 31 : 109.10 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 78,
		LimitedSmallParkNb = '',
		airdromeId = 65,
		code = {
			ICAO = 'OJKA',
		},
		divert = true,
		elevation = 700,
		parkAlertSAR = {
			{
				["y"] = 19820.86372772,
				["x"] = -334700.77327647,
			},
			{
				["y"] = 20377.518355752,
				["x"] = -335144.2984699,
			},			
			{
				["y"] = 20401.647389617,
				["x"] = -335162.94918215,
			},
		},
		runways = {
			{
				hdg = 130,
				length = 1840,
				name = '13-31',
				x = -335494.375,
				y = 20582.703125,
			},
		},
		side = 'blue',
		startup = 900,
		x = -335494.375,
		y = 20582.703125,
	},
	['King Hussein Air College'] = {
		ATC_frequency = {250.4, 118.3, 38.85, 3.975},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 52,
		LimitedSmallParkNb = '',
		airdromeId = 19,
		code = {
			ICAO = 'OJMF',
		},
		divert = false,
		elevation = 672,
		parkAlertSAR = {
			{
				x = -295821.28534191,
				y = 23954.398477784,
			},
			{
				x = -295935.32561919,
				y = 24081.397877481,
			},
			{
				x = -296086.94735148,
				y = 24187.66268131,
			},
			{
				x = -296182.19690125,
				y = 24279.024494358,
			},
			{
				x = -296480.25671687,
				y = 24692.420499497,
			},
			{
				x = -296555.4196269,
				y = 24767.583409522,
			},
			{
				x = -296996.67774524,
				y = 25240.591377784,
			},
			{
				x = -297082.85590932,
				y = 25345.560269372,
			},
		},
		runways = {
			{
				hdg = 127,
				length = 2800,
				name = '13-31',
				x = -296592.405413,
				y = 24944.355658,
			},
		},
		side = 'blue',
		startup = 900,
		x = -296592.405413,
		y = 24944.355658,
	},
	Kingsfield = {
		ATC_frequency = {251.8, 121, 40.25, 4.675},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 2,
		LimitedSmallParkNb = '',
		NDB = 343,
		airdromeId = 45,
		code = {
			ICAO = 'LCRE',
		},
		divert = true,
		elevation = 85,
		parkAlertSAR = {
			{
				x = 7371.2828333565,
				y = -199967.44361212,
			},
			{
				x = 7417.9462490409,
				y = -199888.80711532,
			},
			{
				x = 7449.919330158,
				y = -199830.04577705,
			},
			{
				x = 7475.8434499826,
				y = -199781.65408671,
			},
			{
				x = 7709.1605284045,
				y = -199100.71387265,
			},
			{
				x = 7764.4653173637,
				y = -198978.00637214,
			},
			{
				x = 7614.9695597082,
				y = -199200.08966531,
			},
			{
				x = 7646.9426408253,
				y = -199119.72489385,
			},
		},
		runways = {
			{
				hdg = 58,
				length = 1000,
				name = '06-24',
				x = 7596.761963,
				y = -199426.492188,
			},
		},
		side = 'blue',
		startup = 600,
		x = 7596.761963,
		y = -199426.492188,
	},
	['Kiryat Shmona'] = {
		ATC_frequency = {250.5, 118.4, 38.95, 4.025},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 5,
		LimitedSmallParkNb = '',
		airdromeId = 20,
		code = {
			ICAO = 'LLK3',
		},
		divert = false,
		elevation = 114,
		parkAlertSAR = {
			{
				x = -199844.69828812,
				y = -34834.792514285,
			},
			{
				x = -199806.73824514,
				y = -34807.678197868,
			},
			{
				x = -199767.57312143,
				y = -34776.948639263,
			},
			{
				x = -199730.21561881,
				y = -34747.424161387,
			},
			{
				x = -199698.88351984,
				y = -34720.309844971,
			},
			{
				x = -199597.05419819,
				y = -34635.351653533,
			},
			{
				x = -199538.00524243,
				y = -34587.750964712,
			},
			{
				x = -199462.68769683,
				y = -34531.714710785,
			},
		},
		runways = {
			{
				hdg = 33,
				length = 1000,
				name = '03-21',
				x = -199486.164063,
				y = -34500.691406,
			},
		},
		side = 'blue',
		startup = 600,
		x = -199486.164063,
		y = -34500.691406,
	},
	Kuweires = {
		ATC_frequency = {120.5, 4.325, 250.1, 39.55},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 37,
		LimitedSmallParkNb = '',
		airdromeId = 31,
		code = {
			ICAO = 'OS66',
		},
		divert = false,
		elevation = 366,
		parkAlertSAR = {
			{
				x = 125506.39011836,
				y = 156185.48089854,
			},
			{
				x = 125518.89508565,
				y = 156046.00241719,
			},
			{
				x = 125556.40998753,
				y = 155922.87658537,
			},
			{
				x = 125592.96296885,
				y = 155799.75075356,
			},
			{
				x = 125630.47787073,
				y = 155684.32028623,
			},
			{
				x = 125654.55484383,
				y = 155571.41035826,
			},
			{
				x = 125694.92507667,
				y = 155359.45371464,
			},
			{
				x = 125716.15206275,
				y = 155200.95888526,
			},
		},
		runways = {
			{
				hdg = 95,
				length = 2300,
				name = '10-28',
				x = 125810.890625,
				y = 155253.8125,
			},
		},
		side = 'red',
		startup = 900,
		x = 125810.890625,
		y = 155253.8125,
	},
	LHA_Nassau = {
		ATC_frequency = '254.255',
		LimitedParkNb = 4,
		side = 'blue',
		startup = 300,
		unitname = 'LHA_Nassau',
	},
	LHA_Tarawa = {
		ATC_frequency = '253.255',
		LimitedParkNb = 4,
		side = 'blue',
		startup = 300,
		unitname = 'LHA_Tarawa',
	},
	Lakatamia = {
		ATC_frequency = {251.9, 120.2, 40.35, 4.75},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 8,
		LimitedSmallParkNb = '',
		airdromeId = 48,
		code = {
			ICAO = 'HELIPORT',
		},
		divert = true,
		elevation = 231,
		parkAlertSAR = {
			{
				x = 19685.79621638,
				y = -234954.50104131,
			},
			{
				x = 19653.677771761,
				y = -234902.96214181,
			},
			{
				x = 19623.053208287,
				y = -234854.41100459,
			},
			{
				x = 19598.404169394,
				y = -234793.16187764,
			},
			{
				x = 19593.922525959,
				y = -234916.40707211,
			},
			{
				x = 19573.7551305,
				y = -234840.96607429,
			},
			{
				x = 19552.840794469,
				y = -234780.46388791,
			},
			{
				x = 19544.624448172,
				y = -234891.75803322,
			},
		},
		side = 'blue',
		startup = 300,
		x = 19561.164063,
		y = -234985.75,
	},
	Larnaca = {
		ATC_frequency = {251.9, 121.2, 40.35, 4.725},
		ILS = 'RNW 22 : 110.30 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 94,
		LimitedSmallParkNb = '',
		NDB = '432',
		VOR = '112.80',
		airdromeId = 47,
		code = {
			ICAO = 'LCRE',
		},
		divert = false,
		elevation = 5,
		parkAlertSAR = {
			{
				x = -8462.0583700034,
				y = -209967.5333781,
			},
			{
				x = -8393.1868350141,
				y = -209877.25582548,
			},
			{
				x = -8250.7902829417,
				y = -209688.32445247,
			},
			{
				x = -8186.5722300463,
				y = -209583.15575714,
			},
			{
				x = -8112.1165165444,
				y = -209454.71965135,
			},
			{
				x = -7939.0069826524,
				y = -209294.63986732,
			},
			{
				x = -7856.1750013815,
				y = -209199.70883261,
			},
			{
				x = -7733.3230741033,
				y = -209086.16386952,
			},
		},
		runways = {
			{
				hdg = 43,
				length = 2600,
				name = '04-2',
				x = -7674.737061,
				y = -208843.625,
			},
		},
		side = 'blue',
		startup = 900,
		x = -7674.737061,
		y = -208843.625,
	},
	['Marj Ruhayyil'] = {
		ATC_frequency = {250.65, 120.8, 39.1, 4.1},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 33,
		LimitedSmallParkNb = '',
		NDB = 264,
		airdromeId = 23,
		code = {
			ICAO = 'OS63',
		},
		divert = false,
		elevation = 659,
		parkAlertSAR = {
			{
				x = -194224.91798507,
				y = 45184.031538794,
			},
			{
				x = -194165.11443769,
				y = 45351.77319607,
			},
			{
				x = -194039.67285051,
				y = 45551.604561695,
			},
			{
				x = -193968.20031828,
				y = 45700.384118583,
			},
			{
				x = -193886.5174243,
				y = 45841.870559938,
			},
			{
				x = -193799.0000379,
				y = 45986.274247507,
			},
			{
				x = -193708.56540528,
				y = 46114.633080901,
			},
			{
				x = -193613.75490334,
				y = 46305.712707885,
			},
		},
		runways = {
			{
				hdg = 59,
				length = 2800,
				name = '06L-24R',
				x = -193666.58031617,
				y = 45867.853571783,
			},
			{
				hdg = 59,
				length = 2500,
				name = '06R-24L',
				x = -193661.49654324,
				y = 45873.937184656,
			},
		},
		side = 'red',
		startup = 900,
		x = -193666.58031617,
		y = 45867.853571783,
	},
	['Marj as Sultan North'] = {
		ATC_frequency = {250.6, 122.7, 39.05, 4.075},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 14,
		LimitedSmallParkNb = '',
		airdromeId = 22,
		code = {
			ICAO = 'HELIPORT',
		},
		divert = false,
		elevation = 612,
		parkAlertSAR = {
			{
				x = -170066.27481549,
				y = 47435.499666255,
			},
			{
				x = -170065.2370502,
				y = 47470.783686091,
			},
			{
				x = -170104.15324855,
				y = 47468.708155512,
			},
			{
				x = -170124.38967169,
				y = 47501.91664477,
			},
			{
				x = -170152.4093345,
				y = 47472.340334025,
			},
			{
				x = -170155.52263037,
				y = 47507.624353861,
			},
			{
				x = -170067.19323267,
				y = 47504.602868403,
			},
			{
				x = -170016.98363208,
				y = 47547.581838213,
			},
		},
		side = 'red',
		startup = 300,
		x = -170244.028992,
		y = 47506.718825,
	},
	['Marj as Sultan South'] = {
		ATC_frequency = {252.8, 122.9, 41.25, 5.175},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 20,
		LimitedSmallParkNb = '',
		airdromeId = 8,
		code = {
			ICAO = 'HELIPORT',
		},
		divert = false,
		elevation = 612,
		parkAlertSAR = {
			{
				x = -171689.92659273,
				y = 48082.588982115,
			},
			{
				x = -171736.8976142,
				y = 48076.769563525,
			},
			{
				x = -172023.42319989,
				y = 48184.436400646,
			},
			{
				x = -172018.98531755,
				y = 48232.302131568,
			},
			{
				x = -171787.89844442,
				y = 48339.445290852,
			},
			{
				x = -171785.36251165,
				y = 48163.831946937,
			},
			{
				x = -171908.67224231,
				y = 48219.939459343,
			},
			{
				x = -171664.90570536,
				y = 48404.111576337,
			},
		},
		side = 'red',
		startup = 300,
		x = -171711.336701,
		y = 48243.74032,
	},
	Megiddo = {
		ATC_frequency = {250.7, 119.9, 39.15, 4.125},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 26,
		LimitedSmallParkNb = '',
		airdromeId = 24,
		code = {
			ICAO = 'LLMG',
		},
		divert = false,
		elevation = 55,
		parkAlertSAR = {
			{
				x = -266944.06252476,
				y = -72122.22354225,
			},
			{
				x = -266960.97592429,
				y = -72002.420295622,
			},
			{
				x = -266963.79482421,
				y = -71907.2824233,
			},
			{
				x = -266972.95624895,
				y = -71711.368878815,
			},
			{
				x = -266987.05074855,
				y = -71550.691583338,
			},
			{
				x = -266999.03107321,
				y = -71380.148138139,
			},
			{
				x = -267009.60194792,
				y = -71211.71886788,
			},
			{
				x = -267031.4484223,
				y = -71063.021897065,
			},
		},
		runways = {
			{
				hdg = 88,
				length = 1800,
				name = '09-27',
				x = -266965.015625,
				y = -71068.832031,
			},
		},
		side = 'blue',
		startup = 600,
		x = -266965.015625,
		y = -71068.832031,
	},
	Mezzeh = {
		ATC_frequency = {250.75, 120.7, 39.2, 4.15},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 28,
		LimitedSmallParkNb = '',
		NDB = 358,
		airdromeId = 25,
		code = {
			ICAO = 'OS67',
		},
		divert = false,
		elevation = 728,
		parkAlertSAR = {
			{
				x = -172532.05071169,
				y = 23919.860601187,
			},
			{
				x = -172448.6312483,
				y = 24088.639515496,
			},
			{
				x = -172422.11808551,
				y = 24144.899153599,
			},
			{
				x = -172362.62513488,
				y = 24247.718492202,
			},
			{
				x = -172298.60554669,
				y = 24358.297780887,
			},
			{
				x = -172253.33917121,
				y = 24425.550681608,
			},
			{
				x = -172182.20629544,
				y = 24560.703145557,
			},
			{
				x = -172151.16649511,
				y = 24637.009321375,
			},
		},
		runways = {
			{
				hdg = 56,
				length = 2600,
				name = '06-24',
				x = -172160.453125,
				y = 24865.682617,
			},
		},
		side = 'red',
		startup = 900,
		x = -172160.453125,
		y = 24865.682617,
	},
	Minakh = {
		ATC_frequency = {250.8, 120.6, 39.25, 4.175},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 20,
		LimitedSmallParkNb = '',
		airdromeId = 26,
		code = {
			ICAO = 'OS71',
		},
		divert = false,
		elevation = 492,
		parkAlertSAR = {
			{
				x = 163855.91476161,
				y = 106989.82827691,
			},
			{
				x = 163901.65212354,
				y = 107024.75498965,
			},
			{
				x = 163939.90518988,
				y = 107065.50282118,
			},
			{
				x = 163977.32666782,
				y = 107093.77682674,
			},
			{
				x = 164057.15915409,
				y = 107168.61978262,
			},
			{
				x = 164094.58063203,
				y = 107206.87284896,
			},
			{
				x = 164135.32846357,
				y = 107234.31526611,
			},
			{
				x = 164179.40264869,
				y = 107282.54739323,
			},
		},
		runways = {
			{
				hdg = 96,
				length = 1300,
				name = '10-28',
				x = 163697.53125,
				y = 107430.609375,
			},
		},
		side = 'red',
		startup = 900,
		x = 163697.53125,
		y = 107430.609375,
	},	
	['Muwaffaq Salti'] = {
		ATC_frequency = {252.85, 120.5, 41.3, 5.200},
		ILS = 'RWY 26 : 112.91 || RWY 31 : 112.9 || ',							-- ILS : optionnel
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 123,
		LimitedSmallParkNb = '',
		TACAN = '85X',
		VOR = '113.8',
		airdromeId = 68,
		code = {
			ICAO = 'OJMS',
		},
		divert = true,
		elevation = 499,
		parkAlertSAR = {
			{
				["y"] = 73504.999309071,
				["x"] = -356657.26544204,
			},
			{
				["y"] = 73288.483904898,
				["x"] = -355184.71413435,
			},			
			{
				["y"] = 71776.127969984,
				["x"] = -355140.97879774,
			},
		},
		runways = {
			{
				hdg = 80,
				length = 2310,
				name = '08-26',
				x = -357476.09375,
				y = 72679.550781,
			},
			{
				hdg = 130,
				length = 2900,
				name = '13-31',
				x = -00356530,
				y = 00073954,
			},
		},
		side = 'blue',
		startup = 900,
		x = -357476.09375,
		y = 72679.550781,
	},
	Naqoura = {
		ATC_frequency = {252.2, 122, 40.65, 4.875},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 9,
		LimitedSmallParkNb = '',
		airdromeId = 52,
		code = {
			ICAO = 'HELIPORT',
		},
		divert = false,
		elevation = 115,
		parkAlertSAR = {
			{
				x = -209905.90077224,
				y = -78854.010025149,
			},
			{
				x = -209877.74882844,
				y = -78802.824672779,
			},
			{
				x = -209848.74379543,
				y = -78721.781198194,
			},
			{
				x = -209829.97583289,
				y = -78671.448935031,
			},
			{
				x = -209811.20787036,
				y = -78621.116671867,
			},
			{
				x = -209777.08430211,
				y = -78430.024689687,
			},
			{
				x = -209757.46325037,
				y = -78376.280069699,
			},
			{
				x = -209864.09940114,
				y = -78322.535449711,
			},
		},
		side = 'red',
		startup = 300,
		x = -209938.1875,
		y = -78642.609375,
	},
	Palmyra = {
		ATC_frequency = {250.9, 121.9, 39.35, 4.225},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 22,
		LimitedSmallParkNb = '',
		NDB = '337',
		airdromeId = 28,
		code = {
			ICAO = 'OSPR',
		},
		divert = false,
		elevation = 404,
		parkAlertSAR = {
			{
				x = -55742.166667908,
				y = 218843.08442611,
			},
			{
				x = -55731.655434672,
				y = 218938.36366931,
			},
			{
				x = -55725.213065915,
				y = 219037.03363291,
			},
			{
				x = -55714.023688599,
				y = 219119.76721064,
			},
			{
				x = -55706.225031682,
				y = 219196.05841961,
			},
			{
				x = -55695.035654366,
				y = 219279.80921346,
			},
			{
				x = -55680.794628692,
				y = 219453.41409787,
			},
			{
				x = -55669.266179336,
				y = 219553.10127759,
			},
		},
		runways = {
			{
				hdg = 79,
				length = 2800,
				name = '08-26',
				x = -55704.023438,
				y = 220114.742188,
			},
		},
		side = 'red',
		startup = 900,
		x = -55704.023438,
		y = 220114.742188,
	},
	Paphos = {
		ATC_frequency = {251.85, 119.9, 40.3, 4.7},
		ILS = 'RNW 29 : 108.90 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 49,
		LimitedSmallParkNb = '',
		NDB = '328',
		TACAN = '79X',
		VOR = '117.90',
		airdromeId = 46,
		code = {
			ICAO = 'LCPH',
		},
		divert = true,
		elevation = 13,
		parkAlertSAR = {
			{
				x = -18109.829092509,
				y = -315286.24189781,
			},
			{
				x = -18215.711349836,
				y = -315030.35977593,
			},
			{
				x = -18266.131472373,
				y = -314915.65399716,
			},
			{
				x = -18339.240650051,
				y = -314715.23401008,
			},
			{
				x = -18384.618760334,
				y = -314626.99879564,
			},
			{
				x = -18429.996870617,
				y = -314517.33502912,
			},
			{
				x = -18475.3749809,
				y = -314425.31830549,
			},
			{
				x = -18532.097618754,
				y = -314287.92347158,
			},
		},
		runways = {
			{
				hdg = 109,
				length = 2600,
				name = '11-29',
				x = -18696.34668,
				y = -314208.375,
			},
		},
		side = 'blue',
		startup = 900,
		x = -18696.34668,
		y = -314208.375,
	},
	Pinarbashi = {
		ATC_frequency = {252.15, 121, 40.6, 4.85},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 4,
		LimitedSmallParkNb = '',
		airdromeId = 51,
		code = {
			ICAO = 'HELIPORT',
		},
		divert = true,
		elevation = 235,
		parkAlertSAR = {
			{
				x = 39186.716199248,
				y = -238931.23797511,
			},
			{
				x = 39139.94216643,
				y = -238922.2958806,
			},
			{
				x = 39089.041013069,
				y = -238917.48090663,
			},
			{
				x = 39017.504256994,
				y = -238891.34247653,
			},
			{
				x = 38976.920904991,
				y = -238885.83964914,
			},
			{
				x = 39060.839022693,
				y = -238953.93713809,
			},
			{
				x = 39012.001429604,
				y = -238948.4343107,
			},
			{
				x = 39179.83766501,
				y = -238985.57839559,
			},
		},
		runways = {
			{
				hdg = 162,
				length = 1000,
				name = '16-34',
				x = 38639.882813,
				y = -238774.6875,
			},
		},
		side = 'blue',
		startup = 600,
		x = 38639.882813,
		y = -238774.6875,
	},
	['Prince Hassan'] = {
		ATC_frequency = {252.7, 122.6, 41.15, 5.125},
		ILS = 'RNW 31 : 111.40 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 44,
		LimitedSmallParkNb = '',
		TACAN = '106X',
		airdromeId = 64,
		code = {
			ICAO = 'OJPH',
		},
		divert = true,
		elevation = 655,
		parkAlertSAR = {
			{
				["y"] = 109537.0348966,
				["x"] = -320037.97827579,
			},
			{
				["y"] = 107716.575957,
				["x"] = -319162.14317351,
			},			
			{
				["y"] = 108180.67821343,
				["x"] = -319576.39127239,
			},
		},
		runways = {
			{
				hdg = 130,
				length = 2800,
				name = '13-31',
				x = -320113.40625,
				y = 108294.582031,
			},
		},
		side = 'blue',
		startup = 900,
		x = -320113.40625,
		y = 108294.582031,
	},
	['Qabr as Sitt'] = {
		ATC_frequency = {250.95, 122.6, 39.4, 4.25},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 8,
		LimitedSmallParkNb = '',
		airdromeId = 29,
		code = {
			ICAO = 'HELIPORT',
		},
		divert = false,
		elevation = 651,
		parkAlertSAR = {
			{
				x = -174576.72425779,
				y = 36942.0436563,
			},
			{
				x = -174550.28566327,
				y = 37032.027644654,
			},
			{
				x = -174526.6300787,
				y = 37114.126438153,
			},
			{
				x = -174513.64269894,
				y = 37158.190762347,
			},
			{
				x = -174484.42109447,
				y = 37253.7407706,
			},
			{
				x = -174556.31551816,
				y = 37186.484696829,
			},
			{
				x = -174619.860912,
				y = 37357.175973708,
			},
			{
				x = -174582.75411268,
				y = 37341.405583996,
			},
		},
		runways = {
            {
                hdg = 54,
                length = 274,
                name = '05-23',
                x = -174610.671875,
                y = 37142.67578125,
            },
        },
		side = 'red',
		startup = 300,
		x = -174597.761535,
		y = 37221.970678,
	},
	['Ramat David'] = {
		ATC_frequency = {251.05, 118.6, 39.5, 4.3},
		ILS = 'RNW 33 : 111.10 || ',
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 59,
		LimitedSmallParkNb = '',
		NDB = '368',
		TACAN = '84X',
		VOR = 113.7,
		airdromeId = 30,
		code = {
			ICAO = 'LLRD',
		},
		divert = false,
		elevation = 45,
		parkAlertSAR = {
			{
				x = -259046.75027823,
				y = -76811.58205301,
			},
			{
				x = -259047.97700171,
				y = -76631.253701753,
			},
			{
				x = -259040.0032991,
				y = -76534.955908734,
			},
			{
				x = -259037.54985215,
				y = -76450.925350496,
			},
			{
				x = -259035.70976693,
				y = -76381.615473992,
			},
			{
				x = -259027.73606432,
				y = -76208.034101864,
			},
			{
				x = -259024.66925563,
				y = -76119.710011452,
			},
			{
				x = -259022.82917041,
				y = -76025.865665389,
			},
		},
		runways = {
			{
				hdg = 84,
				length = 2300,
				name = '09-27',
				x = -259102.132813,
				y = -75789.410156,
			},
			{
				hdg = 105,
				length = 2300,
				name = '11-29',
				x = -259881.2795161,
				y = -76006.956719848,
			},
			{
				hdg = 141,
				length = 2300,
				name = '15-33',
				x = -259123.93033524,
				y = -75103.112971055,
			},
		},
		side = 'blue',
		startup = 900,
		x = -259102.132813,
		y = -75789.410156,
	},
	Rayak = {
		ATC_frequency = {251.15, 124.4, 39.6, 4.35},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 12,
		LimitedSmallParkNb = '',
		airdromeId = 32,
		code = {
			ICAO = 'OLRA',
		},
		divert = false,
		elevation = 925,
		parkAlertSAR = {
			{
				x = -131114.76787178,
				y = 3094.9433464254,
			},
			{
				x = -131037.98170387,
				y = 3179.8600838948,
			},
			{
				x = -130971.59995473,
				y = 3249.9776024656,
			},
			{
				x = -130898.60876737,
				y = 3329.5782280561,
			},
			{
				x = -130822.74391121,
				y = 3404.8683504558,
			},
			{
				x = -130766.99473661,
				y = 3468.0890639212,
			},
			{
				x = -130687.39411102,
				y = 3554.8738614965,
			},
			{
				x = -130639.40384216,
				y = 3601.7146628367,
			},
		},
		runways = {
			{
				hdg = 42,
				length = 2800,
				name = '04-22',
				x = -130132.492188,
				y = 4053.336304,
			},
		},
		side = 'red',
		startup = 900,
		x = -130132.492188,
		y = 4053.336304,
	},
	['Rene Mouawad'] = {
		ATC_frequency = {251.2, 121, 39.65, 4.375},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 13,
		LimitedSmallParkNb = '',
		NDB = '450',
		airdromeId = 33,
		code = {
			ICAO = 'OLKA',
		},
		divert = false,
		elevation = 7,
		parkAlertSAR = {
			{
				x = -48769.941102128,
				y = 7474.9028778643,
			},
			{
				x = -48701.990648651,
				y = 7612.5681267705,
			},
			{
				x = -48651.821042936,
				y = 7727.241511261,
			},
			{
				x = -48557.056232142,
				y = 7947.0321648679,
			},
			{
				x = -48475.298356163,
				y = 8094.3556102203,
			},
			{
				x = -48402.03480496,
				y = 8241.4136079234,
			},
			{
				x = -48333.283863796,
				y = 8378.3845949538,
			},
			{
				x = -48273.027247408,
				y = 8505.2685713113,
			},
		},
		runways = {
			{
				hdg = 58,
				length = 2700,
				name = '06-24',
				x = -48306.007813,
				y = 8690.693604,
			},
		},
		side = 'red',
		startup = 900,
		x = -48306.007813,
		y = 8690.693604,
	},
	Reserves = {
		ATC_frequency = '251.0000',
		elevation = 0,
		inactive = true,
		x = 9999999999,
		y = 9999999999,
	},
	['Rosh Pina'] = {
		ATC_frequency = {251.25, 118.45, 39.7, 4.4},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 9,
		LimitedSmallParkNb = '',
		VOR = '115.30',
		airdromeId = 34,
		code = {
			ICAO = 'LLIB',
		},
		divert = false,
		elevation = 279,
		parkAlertSAR = {
			{
				x = -225831.5730323,
				y = -38180.659022475,
			},
			{
				x = -225791.46023905,
				y = -38121.073999479,
			},
			{
				x = -225675.01630522,
				y = -37976.590054829,
			},
			{
				x = -225597.12738627,
				y = -37845.736670995,
			},
			{
				x = -225866.45581115,
				y = -38043.029357438,
			},
			{
				x = -225775.6986224,
				y = -37912.56589862,
			},
			{
				x = -225719.49104529,
				y = -37826.449702483,
			},
			{
				x = -225664.31479986,
				y = -37753.225152475,
			},
		},
		runways = {
			{
				hdg = 49,
				length = 900,
				name = '05-23',
				x = -225596.18304616,
				y = -37750.542548073,
			},
			{
				hdg = 147,
				length = 800,
				name = '15-33',
				x = -225284.07299884,
				y = -37684.089616365,
			},
		},
		side = 'blue',
		startup = 600,
		x = -225596.18304616,
		y = -37750.542548073,
	},
	Ruwayshid = {
		ATC_frequency = {252.4, 122.1, 40.85, 4.975},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 16,
		LimitedSmallParkNb = '',
		airdromeId = 57,
		code = {
			ICAO = '____',
		},
		divert = false,
		elevation = 909,
		parkAlertSAR = {
			{
				x = -294476.67661426,
				y = 294037.75104539,
			},
			{
				x = -294491.3623648,
				y = 294116.68695452,
			},
			{
				x = -294506.96597474,
				y = 294191.95142601,
			},
			{
				x = -294534.50175699,
				y = 294314.02672733,
			},
			{
				x = -294548.26964812,
				y = 294444.36276333,
			},
			{
				x = -294557.4482422,
				y = 294601.31672217,
			},
			{
				x = -294576.72328978,
				y = 294767.44927509,
			},
			{
				x = -294603.34121263,
				y = 294970.29620436,
			},
		},
		runways = {
			{
				hdg = 91,
				length = 2100,
				name = '09-27',
				x = -294535.89286472,
				y = 295088.93917366,
			},
		},
		side = 'red',
		startup = 600,
		x = -294535.89286472,
		y = 295088.93917366,
	},
	Sanliurfa = {
		ATC_frequency = {252.45, 118.4, 40.9, 5.0},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 11,
		LimitedSmallParkNb = '',
		airdromeId = 58,
		code = {
			ICAO = 'LTC5',
		},
		divert = true,
		elevation = 824,
		parkAlertSAR = {
			{
				x = 263518.65317103,
				y = 272820.93833994,
			},
			{
				x = 263596.16661022,
				y = 272883.8755985,
			},
			{
				x = 263674.60131439,
				y = 272955.28629931,
			},
			{
				x = 263738.98801184,
				y = 273013.81966063,
			},
			{
				x = 263797.52137316,
				y = 273065.3290186,
			},
			{
				x = 263911.07609413,
				y = 273170.68906897,
			},
			{
				x = 263966.09745377,
				y = 273215.17442358,
			},
			{
				x = 264010.58280837,
				y = 273257.31844373,
			},
		},
		runways = {
			{
				hdg = 36,
				length = 3900,
				name = '04-22',
				x = 264719.125,
				y = 273812.4375,
			},
		},
		side = 'blue',
		startup = 300,
		x = 264719.125,
		y = 273812.4375,
	},
	Sayqal = {
		ATC_frequency = {251.3, 120.4, 39.75, 4.425},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 59,
		LimitedSmallParkNb = '',
		airdromeId = 35,
		code = {
			ICAO = 'OS68',
		},
		divert = false,
		elevation = 694,
		parkAlertSAR = {
			{
				x = -151699.07330321,
				y = 116181.770784,
			},
			{
				x = -151677.50511741,
				y = 116290.94085906,
			},
			{
				x = -151661.78619184,
				y = 116421.85191092,
			},
			{
				x = -151632.50819308,
				y = 116505.84616968,
			},
			{
				x = -151664.22603124,
				y = 116752.42758346,
			},
			{
				x = -151663.08635198,
				y = 117231.41124828,
			},
			{
				x = -151601.1535311,
				y = 117341.86117513,
			},
			{
				x = -151644.44248729,
				y = 117498.96076769,
			},
		},
		runways = {
			{
				hdg = 55,
				length = 2300,
				name = '25-23',
				x = -151207.92532507,
				y = 116935.82803091,
			},
			{
				hdg = 85,
				length = 2800,
				name = '08-26',
				x = -151954.13113455,
				y = 117310.32064286,
			},
		},
		side = 'red',
		startup = 600,
		x = -151207.92532507,
		y = 116935.82803091,
	},
	Shayrat = {
		ATC_frequency = {251.35, 120.2, 39.8, 4.45},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 56,
		LimitedSmallParkNb = '',
		airdromeId = 36,
		code = {
			ICAO = 'OS65',
		},
		divert = false,
		elevation = 804,
		parkAlertSAR = {
			{
				x = -60742.448918368,
				y = 90019.356661377,
			},
			{
				x = -60874.045610836,
				y = 90284.012231784,
			},
			{
				x = -60976.398593866,
				y = 90490.911476053,
			},
			{
				x = -61108.72637907,
				y = 90687.575422019,
			},
			{
				x = -61233.743236914,
				y = 90965.390661673,
			},
			{
				x = -61401.421359094,
				y = 91242.370518213,
			},
			{
				x = -61474.810860533,
				y = 91399.510391882,
			},
			{
				x = -61532.227352835,
				y = 91489.304605407,
			},
		},
		runways = {
			{
				hdg = 107,
				length = 2800,
				name = '11-29',
				x = -61368.207031,
				y = 90675.136719,
			},
		},
		side = 'red',
		startup = 300,
		x = -61368.207031,
		y = 90675.136719,
	},
	Tabqa = {
		ATC_frequency = {251.4, 118.5, 39.85, 4.475},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 27,
		LimitedSmallParkNb = '',
		airdromeId = 37,
		code = {
			ICAO = 'OS59',
		},
		divert = false,
		elevation = 335,
		parkAlertSAR = {
			{
				x = 77153.024859537,
				y = 242258.23243909,
			},
			{
				x = 77148.940163903,
				y = 242369.10274917,
			},
			{
				x = 77147.773108007,
				y = 242460.13310902,
			},
			{
				x = 77146.022524163,
				y = 242548.82935708,
			},
			{
				x = 77132.601381364,
				y = 242720.38657373,
			},
			{
				x = 77132.017853417,
				y = 242805.58165411,
			},
			{
				x = 77126.766101887,
				y = 242888.44262269,
			},
			{
				x = 77123.848462148,
				y = 242987.64237382,
			},
		},
		runways = {
			{
				hdg = 88,
				length = 2800,
				name = '09-27',
				x = 76964.6875,
				y = 243605.210938,
			},
		},
		side = 'red',
		startup = 300,
		x = 76964.6875,
		y = 243605.210938,
	},
	Taftanaz = {
		ATC_frequency = {251.45, 122.8, 39.9, 4.5},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 48,
		LimitedSmallParkNb = '',
		airdromeId = 38,
		code = {
			ICAO = 'HELIPORT',
		},
		divert = false,
		elevation = 311,
		parkAlertSAR = {
			{
				x = 103533.69185718,
				y = 82265.934893232,
			},
			{
				x = 103526.23964839,
				y = 82362.813607552,
			},
			{
				x = 103510.093196,
				y = 82440.440782487,
			},
			{
				x = 103497.05183061,
				y = 82506.268626833,
			},
			{
				x = 103485.87351742,
				y = 82583.274784369,
			},
			{
				x = 103461.03282144,
				y = 82665.8700985,
			},
			{
				x = 103447.37043865,
				y = 82727.971838449,
			},
			{
				x = 103413.83549908,
				y = 82864.595666335,
			},
		},
		runways = {
			{
				hdg = 95,
				length = 900,
				name = '10-28',
				x = 103485.980469,
				y = 82766.671875,
			},
		},
		side = 'red',
		startup = 600,
		x = 103485.980469,
		y = 82766.671875,
	},
	['Tal Siman'] = {
		ATC_frequency = {121.9, 5.075, 252.6, 41.05},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 4,
		LimitedSmallParkNb = '',
		airdromeId = 60,
		code = {
			ICAO = 'HELIPORT',
		},
		divert = true,
		elevation = 299,
		parkAlertSAR = {
			{
				x = 133187.31095727,
				y = 276593.14172346,
			},
			{
				x = 133201.84803161,
				y = 276532.88660372,
			},
			{
				x = 133223.33761977,
				y = 276444.82142872,
			},
			{
				x = 133244.82720793,
				y = 276361.8126274,
			},
			{
				x = 133268.84498293,
				y = 276288.91657345,
			},
			{
				x = 133290.33457109,
				y = 276214.33506161,
			},
			{
				x = 133306.76778556,
				y = 276153.23721292,
			},
			{
				x = 133386.40567109,
				y = 275996.06826423,
			},
		},
		runways = {
			{
				hdg = 97,
				length = 800,
				name = '10-28',
				x = 133191.875,
				y = 276361.453125,
			},
		},
		side = 'red',
		startup = 600,
		x = 133191.875,
		y = 276361.453125,
	},
	['Tha\'lah'] = {
		ATC_frequency = {252.55, 122.4, 41, 5.05},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 16,
		LimitedSmallParkNb = '',
		airdromeId = 5,
		code = {
			ICAO = 'OS60',
		},
		divert = false,
		elevation = 736,
		parkAlertSAR = {
			{
				x = -258939.60159787,
				y = 39274.453141121,
			},
			{
				x = -259084.98090119,
				y = 39137.35970483,
			},
			{
				x = -258880.09400739,
				y = 39419.83244444,
			},
			{
				x = -258578.78975181,
				y = 39709.0845298,
			},
			{
				x = -258713.62340618,
				y = 39746.747561748,
			},
			{
				x = -258546.39954433,
				y = 39867.269263981,
			},
			{
				x = -258330.21374095,
				y = 40130.910487617,
			},
			{
				x = -258022.88340026,
				y = 40658.192934889,
			},
		},
		runways = {
			{
				hdg = 53,
				length = 2800,
				name = '05-23',
				x = -258434.929688,
				y = 40368.677734,
			},
		},
		side = 'red',
		startup = 300,
		x = -258434.929688,
		y = 40368.677734,
	},
	Tiyas = {
		ATC_frequency = {251.5, 120.5, 39.95, 4.525},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 81,
		LimitedSmallParkNb = '',
		airdromeId = 39,
		code = {
			ICAO = 'OS72',
		},
		divert = false,
		elevation = 548,
		parkAlertSAR = {
			{
				x = -58739.229233307,
				y = 155767.0728849,
			},
			{
				x = -58740.891099331,
				y = 156125.63067918,
			},
			{
				x = -58738.578041492,
				y = 156304.69491405,
			},
			{
				x = -58738.578041492,
				y = 156470.84956882,
			},
			{
				x = -58740.120080052,
				y = 156676.32620685,
			},
			{
				x = -58747.444763208,
				y = 156904.54791363,
			},
			{
				x = -58743.97517645,
				y = 157113.49413842,
			},
			{
				x = -58741.662118611,
				y = 157306.63446798,
			},
		},
		runways = {
			{
				hdg = 85,
				length = 2800,
				name = '09-27',
				x = -58907.53125,
				y = 157071.484375,
			},
		},
		side = 'red',
		startup = 600,
		x = -58907.53125,
		y = 157071.484375,
	},
	['Wujah Al Hajar'] = {
		ATC_frequency = {251.6, 120.5, 40.05, 4.575},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 6,
		LimitedSmallParkNb = '',
		VOR = '116.20',
		airdromeId = 40,
		code = {
			ICAO = 'Z190',
		},
		divert = false,
		elevation = 196,
		parkAlertSAR = {
			{
				x = -82149.842301974,
				y = -23135.208855736,
			},
			{
				x = -82090.408280583,
				y = -23098.285641523,
			},
			{
				x = -82032.209608367,
				y = -23066.715607066,
			},
			{
				x = -81974.422719208,
				y = -23040.086969307,
			},
			{
				x = -81772.786281742,
				y = -22928.493760552,
			},
			{
				x = -81720.21531132,
				y = -22899.119902405,
			},
			{
				x = -81665.448164588,
				y = -22868.922478141,
			},
			{
				x = -81608.759363585,
				y = -22837.626965723,
			},
		},
		runways = {
			{
				hdg = 24,
				length = 1400,
				name = '02-20',
				x = -81524.375,
				y = -22832.533203,
			},
		},
		side = 'red',
		startup = 600,
		x = -81524.375,
		y = -22832.533203,
	},
}
